package io.k8s.api.discovery.v1

import dev.hnaderi.k8s.utils._

/** ForZone provides information about which zones should consume this endpoint. */
final case class ForZone(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ForZone = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ForZone = copy(name = f(name))
}

object ForZone {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.discovery.v1.ForZone, T] = new Encoder[io.k8s.api.discovery.v1.ForZone, T] {
        def apply(o: io.k8s.api.discovery.v1.ForZone) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ForZone] = new Decoder[T, ForZone] {
      def apply(t: T): Either[String, ForZone] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield ForZone (
          name = name
        )
    }
}

