package io.k8s.api.discovery.v1

import dev.hnaderi.k8s.utils._

/** EndpointPort represents a Port used by an EndpointSlice */
final case class EndpointPort(
  appProtocol : Option[String] = None,
  name : Option[String] = None,
  port : Option[Int] = None,
  protocol : Option[String] = None
) {

  /** Returns a new data with appProtocol set to new value */
  def withAppProtocol(value: String) : EndpointPort = copy(appProtocol = Some(value))
  /** if appProtocol has a value, transforms to the result of function*/
  def mapAppProtocol(f: String => String) : EndpointPort = copy(appProtocol = appProtocol.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : EndpointPort = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : EndpointPort = copy(name = name.map(f))

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : EndpointPort = copy(port = Some(value))
  /** if port has a value, transforms to the result of function*/
  def mapPort(f: Int => Int) : EndpointPort = copy(port = port.map(f))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : EndpointPort = copy(protocol = Some(value))
  /** if protocol has a value, transforms to the result of function*/
  def mapProtocol(f: String => String) : EndpointPort = copy(protocol = protocol.map(f))
}

object EndpointPort {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.discovery.v1.EndpointPort, T] = new Encoder[io.k8s.api.discovery.v1.EndpointPort, T] {
        def apply(o: io.k8s.api.discovery.v1.EndpointPort) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("appProtocol", o.appProtocol)
            .write("name", o.name)
            .write("port", o.port)
            .write("protocol", o.protocol)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, EndpointPort] = new Decoder[T, EndpointPort] {
      def apply(t: T): Either[String, EndpointPort] = for {
          obj <- ObjectReader(t)
          appProtocol <- obj.readOpt[String]("appProtocol")
          name <- obj.readOpt[String]("name")
          port <- obj.readOpt[Int]("port")
          protocol <- obj.readOpt[String]("protocol")
      } yield EndpointPort (
          appProtocol = appProtocol,
          name = name,
          port = port,
          protocol = protocol
        )
    }
}

