package io.k8s.api.discovery.v1

import dev.hnaderi.k8s.utils._

/** EndpointHints provides hints describing how an endpoint should be consumed. */
final case class EndpointHints(
  forZones : Option[Seq[io.k8s.api.discovery.v1.ForZone]] = None
) {

  /** Returns a new data with forZones set to new value */
  def withForZones(value: Seq[io.k8s.api.discovery.v1.ForZone]) : EndpointHints = copy(forZones = Some(value))
  /** Appends new values to forZones */
  def addForZones(newValues: io.k8s.api.discovery.v1.ForZone*) : EndpointHints = copy(forZones = Some(forZones.fold(newValues)(_ ++ newValues)))
  /** if forZones has a value, transforms to the result of function*/
  def mapForZones(f: Seq[io.k8s.api.discovery.v1.ForZone] => Seq[io.k8s.api.discovery.v1.ForZone]) : EndpointHints = copy(forZones = forZones.map(f))
}

object EndpointHints {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.discovery.v1.EndpointHints, T] = new Encoder[io.k8s.api.discovery.v1.EndpointHints, T] {
        def apply(o: io.k8s.api.discovery.v1.EndpointHints) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("forZones", o.forZones)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, EndpointHints] = new Decoder[T, EndpointHints] {
      def apply(t: T): Either[String, EndpointHints] = for {
          obj <- ObjectReader(t)
          forZones <- obj.readOpt[Seq[io.k8s.api.discovery.v1.ForZone]]("forZones")
      } yield EndpointHints (
          forZones = forZones
        )
    }
}

