package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s) */
final case class WeightedPodAffinityTerm(
  podAffinityTerm : io.k8s.api.core.v1.PodAffinityTerm,
  weight : Int
) {

  /** Returns a new data with podAffinityTerm set to new value */
  def withPodAffinityTerm(value: io.k8s.api.core.v1.PodAffinityTerm) : WeightedPodAffinityTerm = copy(podAffinityTerm = value)
  /** transforms podAffinityTerm to result of function */
  def mapPodAffinityTerm(f: io.k8s.api.core.v1.PodAffinityTerm => io.k8s.api.core.v1.PodAffinityTerm) : WeightedPodAffinityTerm = copy(podAffinityTerm = f(podAffinityTerm))

  /** Returns a new data with weight set to new value */
  def withWeight(value: Int) : WeightedPodAffinityTerm = copy(weight = value)
  /** transforms weight to result of function */
  def mapWeight(f: Int => Int) : WeightedPodAffinityTerm = copy(weight = f(weight))
}

object WeightedPodAffinityTerm {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.WeightedPodAffinityTerm, T] = new Encoder[io.k8s.api.core.v1.WeightedPodAffinityTerm, T] {
        def apply(o: io.k8s.api.core.v1.WeightedPodAffinityTerm) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("podAffinityTerm", o.podAffinityTerm)
            .write("weight", o.weight)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, WeightedPodAffinityTerm] = new Decoder[T, WeightedPodAffinityTerm] {
      def apply(t: T): Either[String, WeightedPodAffinityTerm] = for {
          obj <- ObjectReader(t)
          podAffinityTerm <- obj.read[io.k8s.api.core.v1.PodAffinityTerm]("podAffinityTerm")
          weight <- obj.read[Int]("weight")
      } yield WeightedPodAffinityTerm (
          podAffinityTerm = podAffinityTerm,
          weight = weight
        )
    }
}

