package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** SessionAffinityConfig represents the configurations of session affinity. */
final case class SessionAffinityConfig(
  clientIP : Option[io.k8s.api.core.v1.ClientIPConfig] = None
) {

  /** Returns a new data with clientIP set to new value */
  def withClientIP(value: io.k8s.api.core.v1.ClientIPConfig) : SessionAffinityConfig = copy(clientIP = Some(value))
  /** if clientIP has a value, transforms to the result of function*/
  def mapClientIP(f: io.k8s.api.core.v1.ClientIPConfig => io.k8s.api.core.v1.ClientIPConfig) : SessionAffinityConfig = copy(clientIP = clientIP.map(f))
}

object SessionAffinityConfig {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.SessionAffinityConfig, T] = new Encoder[io.k8s.api.core.v1.SessionAffinityConfig, T] {
        def apply(o: io.k8s.api.core.v1.SessionAffinityConfig) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("clientIP", o.clientIP)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, SessionAffinityConfig] = new Decoder[T, SessionAffinityConfig] {
      def apply(t: T): Either[String, SessionAffinityConfig] = for {
          obj <- ObjectReader(t)
          clientIP <- obj.readOpt[io.k8s.api.core.v1.ClientIPConfig]("clientIP")
      } yield SessionAffinityConfig (
          clientIP = clientIP
        )
    }
}

