package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodReadinessGate contains the reference to a pod condition */
final case class PodReadinessGate(
  conditionType : String
) {

  /** Returns a new data with conditionType set to new value */
  def withConditionType(value: String) : PodReadinessGate = copy(conditionType = value)
  /** transforms conditionType to result of function */
  def mapConditionType(f: String => String) : PodReadinessGate = copy(conditionType = f(conditionType))
}

object PodReadinessGate {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PodReadinessGate, T] = new Encoder[io.k8s.api.core.v1.PodReadinessGate, T] {
        def apply(o: io.k8s.api.core.v1.PodReadinessGate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditionType", o.conditionType)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodReadinessGate] = new Decoder[T, PodReadinessGate] {
      def apply(t: T): Either[String, PodReadinessGate] = for {
          obj <- ObjectReader(t)
          conditionType <- obj.read[String]("conditionType")
      } yield PodReadinessGate (
          conditionType = conditionType
        )
    }
}

