package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PersistentVolumeClaimCondition contails details about state of pvc */
final case class PersistentVolumeClaimCondition(
  status : String,
  `type` : String,
  lastProbeTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : PersistentVolumeClaimCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : PersistentVolumeClaimCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PersistentVolumeClaimCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : PersistentVolumeClaimCondition = copy(`type` = f(`type`))

  /** Returns a new data with lastProbeTime set to new value */
  def withLastProbeTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PersistentVolumeClaimCondition = copy(lastProbeTime = Some(value))
  /** if lastProbeTime has a value, transforms to the result of function*/
  def mapLastProbeTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PersistentVolumeClaimCondition = copy(lastProbeTime = lastProbeTime.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : PersistentVolumeClaimCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : PersistentVolumeClaimCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PersistentVolumeClaimCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PersistentVolumeClaimCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : PersistentVolumeClaimCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : PersistentVolumeClaimCondition = copy(message = message.map(f))
}

object PersistentVolumeClaimCondition {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimCondition, T] = new Encoder[io.k8s.api.core.v1.PersistentVolumeClaimCondition, T] {
        def apply(o: io.k8s.api.core.v1.PersistentVolumeClaimCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("lastProbeTime", o.lastProbeTime)
            .write("reason", o.reason)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PersistentVolumeClaimCondition] = new Decoder[T, PersistentVolumeClaimCondition] {
      def apply(t: T): Either[String, PersistentVolumeClaimCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          lastProbeTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastProbeTime")
          reason <- obj.readOpt[String]("reason")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
      } yield PersistentVolumeClaimCondition (
          status = status,
          `type` = `type`,
          lastProbeTime = lastProbeTime,
          reason = reason,
          lastTransitionTime = lastTransitionTime,
          message = message
        )
    }
}

