package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes */
final case class PersistentVolume(
  status : Option[io.k8s.api.core.v1.PersistentVolumeStatus] = None,
  spec : Option[io.k8s.api.core.v1.PersistentVolumeSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolume", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.PersistentVolumeStatus) : PersistentVolume = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.PersistentVolumeStatus => io.k8s.api.core.v1.PersistentVolumeStatus) : PersistentVolume = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeSpec) : PersistentVolume = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.PersistentVolumeSpec => io.k8s.api.core.v1.PersistentVolumeSpec) : PersistentVolume = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolume = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolume = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PersistentVolume.encoder[T].apply(this)
}

object PersistentVolume {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PersistentVolume, T] = new Encoder[io.k8s.api.core.v1.PersistentVolume, T] {
        def apply(o: io.k8s.api.core.v1.PersistentVolume) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PersistentVolume] = new Decoder[T, PersistentVolume] {
      def apply(t: T): Either[String, PersistentVolume] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeStatus]("status")
          spec <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PersistentVolume (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

