package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms. */
final case class NodeSelector(
  nodeSelectorTerms : Seq[io.k8s.api.core.v1.NodeSelectorTerm]
) {

  /** Returns a new data with nodeSelectorTerms set to new value */
  def withNodeSelectorTerms(value: Seq[io.k8s.api.core.v1.NodeSelectorTerm]) : NodeSelector = copy(nodeSelectorTerms = value)
  /** Appends new values to nodeSelectorTerms */
  def addNodeSelectorTerms(newValues: io.k8s.api.core.v1.NodeSelectorTerm*) : NodeSelector = copy(nodeSelectorTerms = nodeSelectorTerms ++ newValues)
  /** transforms nodeSelectorTerms to result of function */
  def mapNodeSelectorTerms(f: Seq[io.k8s.api.core.v1.NodeSelectorTerm] => Seq[io.k8s.api.core.v1.NodeSelectorTerm]) : NodeSelector = copy(nodeSelectorTerms = f(nodeSelectorTerms))
}

object NodeSelector {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NodeSelector, T] = new Encoder[io.k8s.api.core.v1.NodeSelector, T] {
        def apply(o: io.k8s.api.core.v1.NodeSelector) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("nodeSelectorTerms", o.nodeSelectorTerms)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NodeSelector] = new Decoder[T, NodeSelector] {
      def apply(t: T): Either[String, NodeSelector] = for {
          obj <- ObjectReader(t)
          nodeSelectorTerms <- obj.read[Seq[io.k8s.api.core.v1.NodeSelectorTerm]]("nodeSelectorTerms")
      } yield NodeSelector (
          nodeSelectorTerms = nodeSelectorTerms
        )
    }
}

