package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeDaemonEndpoints lists ports opened by daemons running on the Node. */
final case class NodeDaemonEndpoints(
  kubeletEndpoint : Option[io.k8s.api.core.v1.DaemonEndpoint] = None
) {

  /** Returns a new data with kubeletEndpoint set to new value */
  def withKubeletEndpoint(value: io.k8s.api.core.v1.DaemonEndpoint) : NodeDaemonEndpoints = copy(kubeletEndpoint = Some(value))
  /** if kubeletEndpoint has a value, transforms to the result of function*/
  def mapKubeletEndpoint(f: io.k8s.api.core.v1.DaemonEndpoint => io.k8s.api.core.v1.DaemonEndpoint) : NodeDaemonEndpoints = copy(kubeletEndpoint = kubeletEndpoint.map(f))
}

object NodeDaemonEndpoints {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NodeDaemonEndpoints, T] = new Encoder[io.k8s.api.core.v1.NodeDaemonEndpoints, T] {
        def apply(o: io.k8s.api.core.v1.NodeDaemonEndpoints) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("kubeletEndpoint", o.kubeletEndpoint)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NodeDaemonEndpoints] = new Decoder[T, NodeDaemonEndpoints] {
      def apply(t: T): Either[String, NodeDaemonEndpoints] = for {
          obj <- ObjectReader(t)
          kubeletEndpoint <- obj.readOpt[io.k8s.api.core.v1.DaemonEndpoint]("kubeletEndpoint")
      } yield NodeDaemonEndpoints (
          kubeletEndpoint = kubeletEndpoint
        )
    }
}

