package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeCondition contains condition information for a node. */
final case class NodeCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  lastHeartbeatTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : NodeCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : NodeCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : NodeCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : NodeCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : NodeCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : NodeCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : NodeCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : NodeCondition = copy(message = message.map(f))

  /** Returns a new data with lastHeartbeatTime set to new value */
  def withLastHeartbeatTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastHeartbeatTime = Some(value))
  /** if lastHeartbeatTime has a value, transforms to the result of function*/
  def mapLastHeartbeatTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastHeartbeatTime = lastHeartbeatTime.map(f))
}

object NodeCondition {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NodeCondition, T] = new Encoder[io.k8s.api.core.v1.NodeCondition, T] {
        def apply(o: io.k8s.api.core.v1.NodeCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("reason", o.reason)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .write("lastHeartbeatTime", o.lastHeartbeatTime)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NodeCondition] = new Decoder[T, NodeCondition] {
      def apply(t: T): Either[String, NodeCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          reason <- obj.readOpt[String]("reason")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
          lastHeartbeatTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastHeartbeatTime")
      } yield NodeCondition (
          status = status,
          `type` = `type`,
          reason = reason,
          lastTransitionTime = lastTransitionTime,
          message = message,
          lastHeartbeatTime = lastHeartbeatTime
        )
    }
}

