package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ContainerStateWaiting is a waiting state of a container. */
final case class ContainerStateWaiting(
  message : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ContainerStateWaiting = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ContainerStateWaiting = copy(message = message.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ContainerStateWaiting = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ContainerStateWaiting = copy(reason = reason.map(f))
}

object ContainerStateWaiting {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ContainerStateWaiting, T] = new Encoder[io.k8s.api.core.v1.ContainerStateWaiting, T] {
        def apply(o: io.k8s.api.core.v1.ContainerStateWaiting) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("message", o.message)
            .write("reason", o.reason)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ContainerStateWaiting] = new Decoder[T, ContainerStateWaiting] {
      def apply(t: T): Either[String, ContainerStateWaiting] = for {
          obj <- ObjectReader(t)
          message <- obj.readOpt[String]("message")
          reason <- obj.readOpt[String]("reason")
      } yield ContainerStateWaiting (
          message = message,
          reason = reason
        )
    }
}

