package io.k8s.api.certificates.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CertificateSigningRequestList is a collection of CertificateSigningRequest objects */
final case class CertificateSigningRequestList(
  items : Seq[io.k8s.api.certificates.v1.CertificateSigningRequest],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("certificates.k8s.io", "CertificateSigningRequestList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.certificates.v1.CertificateSigningRequest]) : CertificateSigningRequestList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.certificates.v1.CertificateSigningRequest*) : CertificateSigningRequestList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.certificates.v1.CertificateSigningRequest] => Seq[io.k8s.api.certificates.v1.CertificateSigningRequest]) : CertificateSigningRequestList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CertificateSigningRequestList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CertificateSigningRequestList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CertificateSigningRequestList.encoder[T].apply(this)
}

object CertificateSigningRequestList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestList, T] = new Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestList, T] {
        def apply(o: io.k8s.api.certificates.v1.CertificateSigningRequestList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CertificateSigningRequestList] = new Decoder[T, CertificateSigningRequestList] {
      def apply(t: T): Either[String, CertificateSigningRequestList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.certificates.v1.CertificateSigningRequest]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield CertificateSigningRequestList (
          items = items,
          metadata = metadata
        )
    }
}

