package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** JobTemplateSpec describes the data a Job should have when created from a template */
final case class JobTemplateSpec(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.batch.v1.JobSpec] = None
) {

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : JobTemplateSpec = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : JobTemplateSpec = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.batch.v1.JobSpec) : JobTemplateSpec = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.batch.v1.JobSpec => io.k8s.api.batch.v1.JobSpec) : JobTemplateSpec = copy(spec = spec.map(f))
}

object JobTemplateSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.batch.v1.JobTemplateSpec, T] = new Encoder[io.k8s.api.batch.v1.JobTemplateSpec, T] {
        def apply(o: io.k8s.api.batch.v1.JobTemplateSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, JobTemplateSpec] = new Decoder[T, JobTemplateSpec] {
      def apply(t: T): Either[String, JobTemplateSpec] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.batch.v1.JobSpec]("spec")
      } yield JobTemplateSpec (
          metadata = metadata,
          spec = spec
        )
    }
}

