package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point. */
final case class HorizontalPodAutoscalerCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : HorizontalPodAutoscalerCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : HorizontalPodAutoscalerCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : HorizontalPodAutoscalerCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : HorizontalPodAutoscalerCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : HorizontalPodAutoscalerCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : HorizontalPodAutoscalerCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : HorizontalPodAutoscalerCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : HorizontalPodAutoscalerCondition = copy(message = message.map(f))
}

object HorizontalPodAutoscalerCondition {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition, T] = new Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition, T] {
        def apply(o: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("reason", o.reason)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, HorizontalPodAutoscalerCondition] = new Decoder[T, HorizontalPodAutoscalerCondition] {
      def apply(t: T): Either[String, HorizontalPodAutoscalerCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          reason <- obj.readOpt[String]("reason")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
      } yield HorizontalPodAutoscalerCondition (
          status = status,
          `type` = `type`,
          reason = reason,
          lastTransitionTime = lastTransitionTime,
          message = message
        )
    }
}

