package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s.utils._

/** ScaleSpec describes the attributes of a scale subresource. */
final case class ScaleSpec(
  replicas : Option[Int] = None
) {

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : ScaleSpec = copy(replicas = Some(value))
  /** if replicas has a value, transforms to the result of function*/
  def mapReplicas(f: Int => Int) : ScaleSpec = copy(replicas = replicas.map(f))
}

object ScaleSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v1.ScaleSpec, T] = new Encoder[io.k8s.api.autoscaling.v1.ScaleSpec, T] {
        def apply(o: io.k8s.api.autoscaling.v1.ScaleSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("replicas", o.replicas)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ScaleSpec] = new Decoder[T, ScaleSpec] {
      def apply(t: T): Either[String, ScaleSpec] = for {
          obj <- ObjectReader(t)
          replicas <- obj.readOpt[Int]("replicas")
      } yield ScaleSpec (
          replicas = replicas
        )
    }
}

