package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.utils._

/** SubjectAccessReviewStatus */
final case class SubjectAccessReviewStatus(
  allowed : Boolean,
  denied : Option[Boolean] = None,
  evaluationError : Option[String] = None,
  reason : Option[String] = None
) {

  /** Returns a new data with allowed set to new value */
  def withAllowed(value: Boolean) : SubjectAccessReviewStatus = copy(allowed = value)
  /** transforms allowed to result of function */
  def mapAllowed(f: Boolean => Boolean) : SubjectAccessReviewStatus = copy(allowed = f(allowed))

  /** Returns a new data with denied set to new value */
  def withDenied(value: Boolean) : SubjectAccessReviewStatus = copy(denied = Some(value))
  /** if denied has a value, transforms to the result of function*/
  def mapDenied(f: Boolean => Boolean) : SubjectAccessReviewStatus = copy(denied = denied.map(f))

  /** Returns a new data with evaluationError set to new value */
  def withEvaluationError(value: String) : SubjectAccessReviewStatus = copy(evaluationError = Some(value))
  /** if evaluationError has a value, transforms to the result of function*/
  def mapEvaluationError(f: String => String) : SubjectAccessReviewStatus = copy(evaluationError = evaluationError.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : SubjectAccessReviewStatus = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : SubjectAccessReviewStatus = copy(reason = reason.map(f))
}

object SubjectAccessReviewStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.authorization.v1.SubjectAccessReviewStatus, T] = new Encoder[io.k8s.api.authorization.v1.SubjectAccessReviewStatus, T] {
        def apply(o: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("allowed", o.allowed)
            .write("denied", o.denied)
            .write("evaluationError", o.evaluationError)
            .write("reason", o.reason)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, SubjectAccessReviewStatus] = new Decoder[T, SubjectAccessReviewStatus] {
      def apply(t: T): Either[String, SubjectAccessReviewStatus] = for {
          obj <- ObjectReader(t)
          allowed <- obj.read[Boolean]("allowed")
          denied <- obj.readOpt[Boolean]("denied")
          evaluationError <- obj.readOpt[String]("evaluationError")
          reason <- obj.readOpt[String]("reason")
      } yield SubjectAccessReviewStatus (
          allowed = allowed,
          denied = denied,
          evaluationError = evaluationError,
          reason = reason
        )
    }
}

