package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.utils._

/** SelfSubjectRulesReviewSpec defines the specification for SelfSubjectRulesReview. */
final case class SelfSubjectRulesReviewSpec(
  namespace : Option[String] = None
) {

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : SelfSubjectRulesReviewSpec = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : SelfSubjectRulesReviewSpec = copy(namespace = namespace.map(f))
}

object SelfSubjectRulesReviewSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec, T] = new Encoder[io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec, T] {
        def apply(o: io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("namespace", o.namespace)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, SelfSubjectRulesReviewSpec] = new Decoder[T, SelfSubjectRulesReviewSpec] {
      def apply(t: T): Either[String, SelfSubjectRulesReviewSpec] = for {
          obj <- ObjectReader(t)
          namespace <- obj.readOpt[String]("namespace")
      } yield SelfSubjectRulesReviewSpec (
          namespace = namespace
        )
    }
}

