package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** StatefulSetStatus represents the current state of a StatefulSet. */
final case class StatefulSetStatus(
  replicas : Int,
  conditions : Option[Seq[io.k8s.api.apps.v1.StatefulSetCondition]] = None,
  collisionCount : Option[Int] = None,
  availableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  currentRevision : Option[String] = None,
  currentReplicas : Option[Int] = None,
  updateRevision : Option[String] = None,
  updatedReplicas : Option[Int] = None,
  readyReplicas : Option[Int] = None
) {

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : StatefulSetStatus = copy(replicas = value)
  /** transforms replicas to result of function */
  def mapReplicas(f: Int => Int) : StatefulSetStatus = copy(replicas = f(replicas))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.apps.v1.StatefulSetCondition]) : StatefulSetStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.apps.v1.StatefulSetCondition*) : StatefulSetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.apps.v1.StatefulSetCondition] => Seq[io.k8s.api.apps.v1.StatefulSetCondition]) : StatefulSetStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with collisionCount set to new value */
  def withCollisionCount(value: Int) : StatefulSetStatus = copy(collisionCount = Some(value))
  /** if collisionCount has a value, transforms to the result of function*/
  def mapCollisionCount(f: Int => Int) : StatefulSetStatus = copy(collisionCount = collisionCount.map(f))

  /** Returns a new data with availableReplicas set to new value */
  def withAvailableReplicas(value: Int) : StatefulSetStatus = copy(availableReplicas = Some(value))
  /** if availableReplicas has a value, transforms to the result of function*/
  def mapAvailableReplicas(f: Int => Int) : StatefulSetStatus = copy(availableReplicas = availableReplicas.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : StatefulSetStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : StatefulSetStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with currentRevision set to new value */
  def withCurrentRevision(value: String) : StatefulSetStatus = copy(currentRevision = Some(value))
  /** if currentRevision has a value, transforms to the result of function*/
  def mapCurrentRevision(f: String => String) : StatefulSetStatus = copy(currentRevision = currentRevision.map(f))

  /** Returns a new data with currentReplicas set to new value */
  def withCurrentReplicas(value: Int) : StatefulSetStatus = copy(currentReplicas = Some(value))
  /** if currentReplicas has a value, transforms to the result of function*/
  def mapCurrentReplicas(f: Int => Int) : StatefulSetStatus = copy(currentReplicas = currentReplicas.map(f))

  /** Returns a new data with updateRevision set to new value */
  def withUpdateRevision(value: String) : StatefulSetStatus = copy(updateRevision = Some(value))
  /** if updateRevision has a value, transforms to the result of function*/
  def mapUpdateRevision(f: String => String) : StatefulSetStatus = copy(updateRevision = updateRevision.map(f))

  /** Returns a new data with updatedReplicas set to new value */
  def withUpdatedReplicas(value: Int) : StatefulSetStatus = copy(updatedReplicas = Some(value))
  /** if updatedReplicas has a value, transforms to the result of function*/
  def mapUpdatedReplicas(f: Int => Int) : StatefulSetStatus = copy(updatedReplicas = updatedReplicas.map(f))

  /** Returns a new data with readyReplicas set to new value */
  def withReadyReplicas(value: Int) : StatefulSetStatus = copy(readyReplicas = Some(value))
  /** if readyReplicas has a value, transforms to the result of function*/
  def mapReadyReplicas(f: Int => Int) : StatefulSetStatus = copy(readyReplicas = readyReplicas.map(f))
}

object StatefulSetStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.StatefulSetStatus, T] = new Encoder[io.k8s.api.apps.v1.StatefulSetStatus, T] {
        def apply(o: io.k8s.api.apps.v1.StatefulSetStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("replicas", o.replicas)
            .write("conditions", o.conditions)
            .write("collisionCount", o.collisionCount)
            .write("availableReplicas", o.availableReplicas)
            .write("observedGeneration", o.observedGeneration)
            .write("currentRevision", o.currentRevision)
            .write("currentReplicas", o.currentReplicas)
            .write("updateRevision", o.updateRevision)
            .write("updatedReplicas", o.updatedReplicas)
            .write("readyReplicas", o.readyReplicas)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, StatefulSetStatus] = new Decoder[T, StatefulSetStatus] {
      def apply(t: T): Either[String, StatefulSetStatus] = for {
          obj <- ObjectReader(t)
          replicas <- obj.read[Int]("replicas")
          conditions <- obj.readOpt[Seq[io.k8s.api.apps.v1.StatefulSetCondition]]("conditions")
          collisionCount <- obj.readOpt[Int]("collisionCount")
          availableReplicas <- obj.readOpt[Int]("availableReplicas")
          observedGeneration <- obj.readOpt[Int]("observedGeneration")
          currentRevision <- obj.readOpt[String]("currentRevision")
          currentReplicas <- obj.readOpt[Int]("currentReplicas")
          updateRevision <- obj.readOpt[String]("updateRevision")
          updatedReplicas <- obj.readOpt[Int]("updatedReplicas")
          readyReplicas <- obj.readOpt[Int]("readyReplicas")
      } yield StatefulSetStatus (
          replicas = replicas,
          conditions = conditions,
          collisionCount = collisionCount,
          availableReplicas = availableReplicas,
          observedGeneration = observedGeneration,
          currentRevision = currentRevision,
          currentReplicas = currentReplicas,
          updateRevision = updateRevision,
          updatedReplicas = updatedReplicas,
          readyReplicas = readyReplicas
        )
    }
}

