package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** DeploymentStrategy describes how to replace existing pods with new ones. */
final case class DeploymentStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateDeployment] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with rollingUpdate set to new value */
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateDeployment) : DeploymentStrategy = copy(rollingUpdate = Some(value))
  /** if rollingUpdate has a value, transforms to the result of function*/
  def mapRollingUpdate(f: io.k8s.api.apps.v1.RollingUpdateDeployment => io.k8s.api.apps.v1.RollingUpdateDeployment) : DeploymentStrategy = copy(rollingUpdate = rollingUpdate.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : DeploymentStrategy = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : DeploymentStrategy = copy(`type` = `type`.map(f))
}

object DeploymentStrategy {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.DeploymentStrategy, T] = new Encoder[io.k8s.api.apps.v1.DeploymentStrategy, T] {
        def apply(o: io.k8s.api.apps.v1.DeploymentStrategy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rollingUpdate", o.rollingUpdate)
            .write("type", o.`type`)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, DeploymentStrategy] = new Decoder[T, DeploymentStrategy] {
      def apply(t: T): Either[String, DeploymentStrategy] = for {
          obj <- ObjectReader(t)
          rollingUpdate <- obj.readOpt[io.k8s.api.apps.v1.RollingUpdateDeployment]("rollingUpdate")
          `type` <- obj.readOpt[String]("type")
      } yield DeploymentStrategy (
          rollingUpdate = rollingUpdate,
          `type` = `type`
        )
    }
}

