package io.k8s.api.apps.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ControllerRevisionList is a resource containing a list of ControllerRevision objects. */
final case class ControllerRevisionList(
  items : Seq[io.k8s.api.apps.v1.ControllerRevision],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ControllerRevisionList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.apps.v1.ControllerRevision]) : ControllerRevisionList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.apps.v1.ControllerRevision*) : ControllerRevisionList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.apps.v1.ControllerRevision] => Seq[io.k8s.api.apps.v1.ControllerRevision]) : ControllerRevisionList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ControllerRevisionList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ControllerRevisionList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ControllerRevisionList.encoder[T].apply(this)
}

object ControllerRevisionList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.ControllerRevisionList, T] = new Encoder[io.k8s.api.apps.v1.ControllerRevisionList, T] {
        def apply(o: io.k8s.api.apps.v1.ControllerRevisionList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ControllerRevisionList] = new Decoder[T, ControllerRevisionList] {
      def apply(t: T): Either[String, ControllerRevisionList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.apps.v1.ControllerRevision]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ControllerRevisionList (
          items = items,
          metadata = metadata
        )
    }
}

