package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.utils._

/** ServiceReference holds a reference to Service.legacy.k8s.io */
final case class ServiceReference(
  name : String,
  namespace : String,
  path : Option[String] = None,
  port : Option[Int] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ServiceReference = copy(name = f(name))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ServiceReference = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ServiceReference = copy(namespace = f(namespace))

  /** Returns a new data with path set to new value */
  def withPath(value: String) : ServiceReference = copy(path = Some(value))
  /** if path has a value, transforms to the result of function*/
  def mapPath(f: String => String) : ServiceReference = copy(path = path.map(f))

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : ServiceReference = copy(port = Some(value))
  /** if port has a value, transforms to the result of function*/
  def mapPort(f: Int => Int) : ServiceReference = copy(port = port.map(f))
}

object ServiceReference {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.admissionregistration.v1.ServiceReference, T] = new Encoder[io.k8s.api.admissionregistration.v1.ServiceReference, T] {
        def apply(o: io.k8s.api.admissionregistration.v1.ServiceReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("namespace", o.namespace)
            .write("path", o.path)
            .write("port", o.port)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ServiceReference] = new Decoder[T, ServiceReference] {
      def apply(t: T): Either[String, ServiceReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          namespace <- obj.read[String]("namespace")
          path <- obj.readOpt[String]("path")
          port <- obj.readOpt[Int]("port")
      } yield ServiceReference (
          name = name,
          namespace = namespace,
          path = path,
          port = port
        )
    }
}

