package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s.utils._

/** SelectableField specifies the JSON path of a field that may be used with field selectors. */
final case class SelectableField(
  jsonPath : String
) {

  /** Returns a new data with jsonPath set to new value */
  def withJsonPath(value: String) : SelectableField = copy(jsonPath = value)
  /** transforms jsonPath to result of function */
  def mapJsonPath(f: String => String) : SelectableField = copy(jsonPath = f(jsonPath))
}

object SelectableField {

    implicit val encoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField] {
        def apply[T : Builder](o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("jsonPath", o.jsonPath)
            .build
        }
    }

    implicit val decoder: Decoder[SelectableField] = new Decoder[SelectableField] {
      def apply[T : Reader](t: T): Either[String, SelectableField] = for {
          obj <- ObjectReader(t)
          jsonPath <- obj.read[String]("jsonPath")
      } yield SelectableField (
          jsonPath = jsonPath
        )
    }
}

