package io.k8s.api.storagemigration.v1alpha1

import dev.hnaderi.k8s.utils._

/** Describes the state of a migration at a certain point. */
final case class MigrationCondition(
  status : String,
  `type` : String,
  lastUpdateTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : MigrationCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : MigrationCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : MigrationCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : MigrationCondition = copy(`type` = f(`type`))

  /** Returns a new data with lastUpdateTime set to new value */
  def withLastUpdateTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : MigrationCondition = copy(lastUpdateTime = Some(value))
  /** if lastUpdateTime has a value, transforms to the result of function*/
  def mapLastUpdateTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : MigrationCondition = copy(lastUpdateTime = lastUpdateTime.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : MigrationCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : MigrationCondition = copy(reason = reason.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : MigrationCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : MigrationCondition = copy(message = message.map(f))
}

object MigrationCondition {

    implicit val encoder : Encoder[io.k8s.api.storagemigration.v1alpha1.MigrationCondition] = new Encoder[io.k8s.api.storagemigration.v1alpha1.MigrationCondition] {
        def apply[T : Builder](o: io.k8s.api.storagemigration.v1alpha1.MigrationCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("lastUpdateTime", o.lastUpdateTime)
            .write("reason", o.reason)
            .write("message", o.message)
            .build
        }
    }

    implicit val decoder: Decoder[MigrationCondition] = new Decoder[MigrationCondition] {
      def apply[T : Reader](t: T): Either[String, MigrationCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          lastUpdateTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastUpdateTime")
          reason <- obj.readOpt[String]("reason")
          message <- obj.readOpt[String]("message")
      } yield MigrationCondition (
          status = status,
          `type` = `type`,
          lastUpdateTime = lastUpdateTime,
          reason = reason,
          message = message
        )
    }
}

