package io.k8s.api.storage.v1

import dev.hnaderi.k8s.utils._

/** CSIDriverSpec is the specification of a CSIDriver. */
final case class CSIDriverSpec(
  volumeLifecycleModes : Option[Seq[String]] = None,
  podInfoOnMount : Option[Boolean] = None,
  attachRequired : Option[Boolean] = None,
  requiresRepublish : Option[Boolean] = None,
  fsGroupPolicy : Option[String] = None,
  storageCapacity : Option[Boolean] = None,
  tokenRequests : Option[Seq[io.k8s.api.storage.v1.TokenRequest]] = None,
  seLinuxMount : Option[Boolean] = None
) {

  /** Returns a new data with volumeLifecycleModes set to new value */
  def withVolumeLifecycleModes(value: Seq[String]) : CSIDriverSpec = copy(volumeLifecycleModes = Some(value))
  /** Appends new values to volumeLifecycleModes */
  def addVolumeLifecycleModes(newValues: String*) : CSIDriverSpec = copy(volumeLifecycleModes = Some(volumeLifecycleModes.fold(newValues)(_ ++ newValues)))
  /** if volumeLifecycleModes has a value, transforms to the result of function*/
  def mapVolumeLifecycleModes(f: Seq[String] => Seq[String]) : CSIDriverSpec = copy(volumeLifecycleModes = volumeLifecycleModes.map(f))

  /** Returns a new data with podInfoOnMount set to new value */
  def withPodInfoOnMount(value: Boolean) : CSIDriverSpec = copy(podInfoOnMount = Some(value))
  /** if podInfoOnMount has a value, transforms to the result of function*/
  def mapPodInfoOnMount(f: Boolean => Boolean) : CSIDriverSpec = copy(podInfoOnMount = podInfoOnMount.map(f))

  /** Returns a new data with attachRequired set to new value */
  def withAttachRequired(value: Boolean) : CSIDriverSpec = copy(attachRequired = Some(value))
  /** if attachRequired has a value, transforms to the result of function*/
  def mapAttachRequired(f: Boolean => Boolean) : CSIDriverSpec = copy(attachRequired = attachRequired.map(f))

  /** Returns a new data with requiresRepublish set to new value */
  def withRequiresRepublish(value: Boolean) : CSIDriverSpec = copy(requiresRepublish = Some(value))
  /** if requiresRepublish has a value, transforms to the result of function*/
  def mapRequiresRepublish(f: Boolean => Boolean) : CSIDriverSpec = copy(requiresRepublish = requiresRepublish.map(f))

  /** Returns a new data with fsGroupPolicy set to new value */
  def withFsGroupPolicy(value: String) : CSIDriverSpec = copy(fsGroupPolicy = Some(value))
  /** if fsGroupPolicy has a value, transforms to the result of function*/
  def mapFsGroupPolicy(f: String => String) : CSIDriverSpec = copy(fsGroupPolicy = fsGroupPolicy.map(f))

  /** Returns a new data with storageCapacity set to new value */
  def withStorageCapacity(value: Boolean) : CSIDriverSpec = copy(storageCapacity = Some(value))
  /** if storageCapacity has a value, transforms to the result of function*/
  def mapStorageCapacity(f: Boolean => Boolean) : CSIDriverSpec = copy(storageCapacity = storageCapacity.map(f))

  /** Returns a new data with tokenRequests set to new value */
  def withTokenRequests(value: Seq[io.k8s.api.storage.v1.TokenRequest]) : CSIDriverSpec = copy(tokenRequests = Some(value))
  /** Appends new values to tokenRequests */
  def addTokenRequests(newValues: io.k8s.api.storage.v1.TokenRequest*) : CSIDriverSpec = copy(tokenRequests = Some(tokenRequests.fold(newValues)(_ ++ newValues)))
  /** if tokenRequests has a value, transforms to the result of function*/
  def mapTokenRequests(f: Seq[io.k8s.api.storage.v1.TokenRequest] => Seq[io.k8s.api.storage.v1.TokenRequest]) : CSIDriverSpec = copy(tokenRequests = tokenRequests.map(f))

  /** Returns a new data with seLinuxMount set to new value */
  def withSeLinuxMount(value: Boolean) : CSIDriverSpec = copy(seLinuxMount = Some(value))
  /** if seLinuxMount has a value, transforms to the result of function*/
  def mapSeLinuxMount(f: Boolean => Boolean) : CSIDriverSpec = copy(seLinuxMount = seLinuxMount.map(f))
}

object CSIDriverSpec {

    implicit val encoder : Encoder[io.k8s.api.storage.v1.CSIDriverSpec] = new Encoder[io.k8s.api.storage.v1.CSIDriverSpec] {
        def apply[T : Builder](o: io.k8s.api.storage.v1.CSIDriverSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("volumeLifecycleModes", o.volumeLifecycleModes)
            .write("podInfoOnMount", o.podInfoOnMount)
            .write("attachRequired", o.attachRequired)
            .write("requiresRepublish", o.requiresRepublish)
            .write("fsGroupPolicy", o.fsGroupPolicy)
            .write("storageCapacity", o.storageCapacity)
            .write("tokenRequests", o.tokenRequests)
            .write("seLinuxMount", o.seLinuxMount)
            .build
        }
    }

    implicit val decoder: Decoder[CSIDriverSpec] = new Decoder[CSIDriverSpec] {
      def apply[T : Reader](t: T): Either[String, CSIDriverSpec] = for {
          obj <- ObjectReader(t)
          volumeLifecycleModes <- obj.readOpt[Seq[String]]("volumeLifecycleModes")
          podInfoOnMount <- obj.readOpt[Boolean]("podInfoOnMount")
          attachRequired <- obj.readOpt[Boolean]("attachRequired")
          requiresRepublish <- obj.readOpt[Boolean]("requiresRepublish")
          fsGroupPolicy <- obj.readOpt[String]("fsGroupPolicy")
          storageCapacity <- obj.readOpt[Boolean]("storageCapacity")
          tokenRequests <- obj.readOpt[Seq[io.k8s.api.storage.v1.TokenRequest]]("tokenRequests")
          seLinuxMount <- obj.readOpt[Boolean]("seLinuxMount")
      } yield CSIDriverSpec (
          volumeLifecycleModes = volumeLifecycleModes,
          podInfoOnMount = podInfoOnMount,
          attachRequired = attachRequired,
          requiresRepublish = requiresRepublish,
          fsGroupPolicy = fsGroupPolicy,
          storageCapacity = storageCapacity,
          tokenRequests = tokenRequests,
          seLinuxMount = seLinuxMount
        )
    }
}

