package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** ResourceFilter is a filter for resources from one particular driver. */
final case class ResourceFilter(
  driverName : Option[String] = None,
  namedResources : Option[io.k8s.api.resource.v1alpha2.NamedResourcesFilter] = None
) {

  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : ResourceFilter = copy(driverName = Some(value))
  /** if driverName has a value, transforms to the result of function*/
  def mapDriverName(f: String => String) : ResourceFilter = copy(driverName = driverName.map(f))

  /** Returns a new data with namedResources set to new value */
  def withNamedResources(value: io.k8s.api.resource.v1alpha2.NamedResourcesFilter) : ResourceFilter = copy(namedResources = Some(value))
  /** if namedResources has a value, transforms to the result of function*/
  def mapNamedResources(f: io.k8s.api.resource.v1alpha2.NamedResourcesFilter => io.k8s.api.resource.v1alpha2.NamedResourcesFilter) : ResourceFilter = copy(namedResources = namedResources.map(f))
}

object ResourceFilter {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceFilter] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceFilter] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceFilter) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverName", o.driverName)
            .write("namedResources", o.namedResources)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceFilter] = new Decoder[ResourceFilter] {
      def apply[T : Reader](t: T): Either[String, ResourceFilter] = for {
          obj <- ObjectReader(t)
          driverName <- obj.readOpt[String]("driverName")
          namedResources <- obj.readOpt[io.k8s.api.resource.v1alpha2.NamedResourcesFilter]("namedResources")
      } yield ResourceFilter (
          driverName = driverName,
          namedResources = namedResources
        )
    }
}

