package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ResourceClaimParameters defines resource requests for a ResourceClaim in an in-tree format understood by Kubernetes. */
final case class ResourceClaimParameters(
  driverRequests : Option[Seq[io.k8s.api.resource.v1alpha2.DriverRequests]] = None,
  generatedFrom : Option[io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  shareable : Option[Boolean] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("resource.k8s.io", "ResourceClaimParameters", "v1alpha2")


  /** Returns a new data with driverRequests set to new value */
  def withDriverRequests(value: Seq[io.k8s.api.resource.v1alpha2.DriverRequests]) : ResourceClaimParameters = copy(driverRequests = Some(value))
  /** Appends new values to driverRequests */
  def addDriverRequests(newValues: io.k8s.api.resource.v1alpha2.DriverRequests*) : ResourceClaimParameters = copy(driverRequests = Some(driverRequests.fold(newValues)(_ ++ newValues)))
  /** if driverRequests has a value, transforms to the result of function*/
  def mapDriverRequests(f: Seq[io.k8s.api.resource.v1alpha2.DriverRequests] => Seq[io.k8s.api.resource.v1alpha2.DriverRequests]) : ResourceClaimParameters = copy(driverRequests = driverRequests.map(f))

  /** Returns a new data with generatedFrom set to new value */
  def withGeneratedFrom(value: io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference) : ResourceClaimParameters = copy(generatedFrom = Some(value))
  /** if generatedFrom has a value, transforms to the result of function*/
  def mapGeneratedFrom(f: io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference => io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference) : ResourceClaimParameters = copy(generatedFrom = generatedFrom.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaimParameters = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ResourceClaimParameters = copy(metadata = metadata.map(f))

  /** Returns a new data with shareable set to new value */
  def withShareable(value: Boolean) : ResourceClaimParameters = copy(shareable = Some(value))
  /** if shareable has a value, transforms to the result of function*/
  def mapShareable(f: Boolean => Boolean) : ResourceClaimParameters = copy(shareable = shareable.map(f))

  override def foldTo[T : Builder] : T = ResourceClaimParameters.encoder.apply(this)
}

object ResourceClaimParameters {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimParameters] = new Encoder[io.k8s.api.resource.v1alpha2.ResourceClaimParameters] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.ResourceClaimParameters) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverRequests", o.driverRequests)
            .write("generatedFrom", o.generatedFrom)
            .write("metadata", o.metadata)
            .write("shareable", o.shareable)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ResourceClaimParameters] = new Decoder[ResourceClaimParameters] {
      def apply[T : Reader](t: T): Either[String, ResourceClaimParameters] = for {
          obj <- ObjectReader(t)
          driverRequests <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.DriverRequests]]("driverRequests")
          generatedFrom <- obj.readOpt[io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference]("generatedFrom")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          shareable <- obj.readOpt[Boolean]("shareable")
      } yield ResourceClaimParameters (
          driverRequests = driverRequests,
          generatedFrom = generatedFrom,
          metadata = metadata,
          shareable = shareable
        )
    }
}

