package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesResources is used in ResourceModel. */
final case class NamedResourcesResources(
  instances : Seq[io.k8s.api.resource.v1alpha2.NamedResourcesInstance]
) {

  /** Returns a new data with instances set to new value */
  def withInstances(value: Seq[io.k8s.api.resource.v1alpha2.NamedResourcesInstance]) : NamedResourcesResources = copy(instances = value)
  /** Appends new values to instances */
  def addInstances(newValues: io.k8s.api.resource.v1alpha2.NamedResourcesInstance*) : NamedResourcesResources = copy(instances = instances ++ newValues)
  /** transforms instances to result of function */
  def mapInstances(f: Seq[io.k8s.api.resource.v1alpha2.NamedResourcesInstance] => Seq[io.k8s.api.resource.v1alpha2.NamedResourcesInstance]) : NamedResourcesResources = copy(instances = f(instances))
}

object NamedResourcesResources {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesResources] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesResources] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesResources) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("instances", o.instances)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesResources] = new Decoder[NamedResourcesResources] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesResources] = for {
          obj <- ObjectReader(t)
          instances <- obj.read[Seq[io.k8s.api.resource.v1alpha2.NamedResourcesInstance]]("instances")
      } yield NamedResourcesResources (
          instances = instances
        )
    }
}

