package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.utils._

/** NamedResourcesInstance represents one individual hardware instance that can be selected based on its attributes. */
final case class NamedResourcesInstance(
  name : String,
  attributes : Option[Seq[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute]] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : NamedResourcesInstance = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : NamedResourcesInstance = copy(name = f(name))

  /** Returns a new data with attributes set to new value */
  def withAttributes(value: Seq[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute]) : NamedResourcesInstance = copy(attributes = Some(value))
  /** Appends new values to attributes */
  def addAttributes(newValues: io.k8s.api.resource.v1alpha2.NamedResourcesAttribute*) : NamedResourcesInstance = copy(attributes = Some(attributes.fold(newValues)(_ ++ newValues)))
  /** if attributes has a value, transforms to the result of function*/
  def mapAttributes(f: Seq[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute] => Seq[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute]) : NamedResourcesInstance = copy(attributes = attributes.map(f))
}

object NamedResourcesInstance {

    implicit val encoder : Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesInstance] = new Encoder[io.k8s.api.resource.v1alpha2.NamedResourcesInstance] {
        def apply[T : Builder](o: io.k8s.api.resource.v1alpha2.NamedResourcesInstance) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("attributes", o.attributes)
            .build
        }
    }

    implicit val decoder: Decoder[NamedResourcesInstance] = new Decoder[NamedResourcesInstance] {
      def apply[T : Reader](t: T): Either[String, NamedResourcesInstance] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          attributes <- obj.readOpt[Seq[io.k8s.api.resource.v1alpha2.NamedResourcesAttribute]]("attributes")
      } yield NamedResourcesInstance (
          name = name,
          attributes = attributes
        )
    }
}

