package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** IPAddressSpec describe the attributes in an IP Address. */
final case class IPAddressSpec(
  parentRef : io.k8s.api.networking.v1alpha1.ParentReference
) {

  /** Returns a new data with parentRef set to new value */
  def withParentRef(value: io.k8s.api.networking.v1alpha1.ParentReference) : IPAddressSpec = copy(parentRef = value)
  /** transforms parentRef to result of function */
  def mapParentRef(f: io.k8s.api.networking.v1alpha1.ParentReference => io.k8s.api.networking.v1alpha1.ParentReference) : IPAddressSpec = copy(parentRef = f(parentRef))
}

object IPAddressSpec {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.IPAddressSpec] = new Encoder[io.k8s.api.networking.v1alpha1.IPAddressSpec] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.IPAddressSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("parentRef", o.parentRef)
            .build
        }
    }

    implicit val decoder: Decoder[IPAddressSpec] = new Decoder[IPAddressSpec] {
      def apply[T : Reader](t: T): Either[String, IPAddressSpec] = for {
          obj <- ObjectReader(t)
          parentRef <- obj.read[io.k8s.api.networking.v1alpha1.ParentReference]("parentRef")
      } yield IPAddressSpec (
          parentRef = parentRef
        )
    }
}

