package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** LimitResponse defines how to handle requests that can not be executed right now. */
final case class LimitResponse(
  `type` : String,
  queuing : Option[io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : LimitResponse = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : LimitResponse = copy(`type` = f(`type`))

  /** Returns a new data with queuing set to new value */
  def withQueuing(value: io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration) : LimitResponse = copy(queuing = Some(value))
  /** if queuing has a value, transforms to the result of function*/
  def mapQueuing(f: io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration => io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration) : LimitResponse = copy(queuing = queuing.map(f))
}

object LimitResponse {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.LimitResponse] = new Encoder[io.k8s.api.flowcontrol.v1beta3.LimitResponse] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.LimitResponse) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("queuing", o.queuing)
            .build
        }
    }

    implicit val decoder: Decoder[LimitResponse] = new Decoder[LimitResponse] {
      def apply[T : Reader](t: T): Either[String, LimitResponse] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          queuing <- obj.readOpt[io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration]("queuing")
      } yield LimitResponse (
          `type` = `type`,
          queuing = queuing
        )
    }
}

