package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** EnvVarSource represents a source for the value of an EnvVar. */
final case class EnvVarSource(
  configMapKeyRef : Option[io.k8s.api.core.v1.ConfigMapKeySelector] = None,
  fieldRef : Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  resourceFieldRef : Option[io.k8s.api.core.v1.ResourceFieldSelector] = None,
  secretKeyRef : Option[io.k8s.api.core.v1.SecretKeySelector] = None
) {

  /** Returns a new data with configMapKeyRef set to new value */
  def withConfigMapKeyRef(value: io.k8s.api.core.v1.ConfigMapKeySelector) : EnvVarSource = copy(configMapKeyRef = Some(value))
  /** if configMapKeyRef has a value, transforms to the result of function*/
  def mapConfigMapKeyRef(f: io.k8s.api.core.v1.ConfigMapKeySelector => io.k8s.api.core.v1.ConfigMapKeySelector) : EnvVarSource = copy(configMapKeyRef = configMapKeyRef.map(f))

  /** Returns a new data with fieldRef set to new value */
  def withFieldRef(value: io.k8s.api.core.v1.ObjectFieldSelector) : EnvVarSource = copy(fieldRef = Some(value))
  /** if fieldRef has a value, transforms to the result of function*/
  def mapFieldRef(f: io.k8s.api.core.v1.ObjectFieldSelector => io.k8s.api.core.v1.ObjectFieldSelector) : EnvVarSource = copy(fieldRef = fieldRef.map(f))

  /** Returns a new data with resourceFieldRef set to new value */
  def withResourceFieldRef(value: io.k8s.api.core.v1.ResourceFieldSelector) : EnvVarSource = copy(resourceFieldRef = Some(value))
  /** if resourceFieldRef has a value, transforms to the result of function*/
  def mapResourceFieldRef(f: io.k8s.api.core.v1.ResourceFieldSelector => io.k8s.api.core.v1.ResourceFieldSelector) : EnvVarSource = copy(resourceFieldRef = resourceFieldRef.map(f))

  /** Returns a new data with secretKeyRef set to new value */
  def withSecretKeyRef(value: io.k8s.api.core.v1.SecretKeySelector) : EnvVarSource = copy(secretKeyRef = Some(value))
  /** if secretKeyRef has a value, transforms to the result of function*/
  def mapSecretKeyRef(f: io.k8s.api.core.v1.SecretKeySelector => io.k8s.api.core.v1.SecretKeySelector) : EnvVarSource = copy(secretKeyRef = secretKeyRef.map(f))
}

object EnvVarSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.EnvVarSource] = new Encoder[io.k8s.api.core.v1.EnvVarSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.EnvVarSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("configMapKeyRef", o.configMapKeyRef)
            .write("fieldRef", o.fieldRef)
            .write("resourceFieldRef", o.resourceFieldRef)
            .write("secretKeyRef", o.secretKeyRef)
            .build
        }
    }

    implicit val decoder: Decoder[EnvVarSource] = new Decoder[EnvVarSource] {
      def apply[T : Reader](t: T): Either[String, EnvVarSource] = for {
          obj <- ObjectReader(t)
          configMapKeyRef <- obj.readOpt[io.k8s.api.core.v1.ConfigMapKeySelector]("configMapKeyRef")
          fieldRef <- obj.readOpt[io.k8s.api.core.v1.ObjectFieldSelector]("fieldRef")
          resourceFieldRef <- obj.readOpt[io.k8s.api.core.v1.ResourceFieldSelector]("resourceFieldRef")
          secretKeyRef <- obj.readOpt[io.k8s.api.core.v1.SecretKeySelector]("secretKeyRef")
      } yield EnvVarSource (
          configMapKeyRef = configMapKeyRef,
          fieldRef = fieldRef,
          resourceFieldRef = resourceFieldRef,
          secretKeyRef = secretKeyRef
        )
    }
}

