package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** SuccessPolicyRule describes rule for declaring a Job as succeeded. Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified. */
final case class SuccessPolicyRule(
  succeededCount : Option[Int] = None,
  succeededIndexes : Option[String] = None
) {

  /** Returns a new data with succeededCount set to new value */
  def withSucceededCount(value: Int) : SuccessPolicyRule = copy(succeededCount = Some(value))
  /** if succeededCount has a value, transforms to the result of function*/
  def mapSucceededCount(f: Int => Int) : SuccessPolicyRule = copy(succeededCount = succeededCount.map(f))

  /** Returns a new data with succeededIndexes set to new value */
  def withSucceededIndexes(value: String) : SuccessPolicyRule = copy(succeededIndexes = Some(value))
  /** if succeededIndexes has a value, transforms to the result of function*/
  def mapSucceededIndexes(f: String => String) : SuccessPolicyRule = copy(succeededIndexes = succeededIndexes.map(f))
}

object SuccessPolicyRule {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.SuccessPolicyRule] = new Encoder[io.k8s.api.batch.v1.SuccessPolicyRule] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.SuccessPolicyRule) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("succeededCount", o.succeededCount)
            .write("succeededIndexes", o.succeededIndexes)
            .build
        }
    }

    implicit val decoder: Decoder[SuccessPolicyRule] = new Decoder[SuccessPolicyRule] {
      def apply[T : Reader](t: T): Either[String, SuccessPolicyRule] = for {
          obj <- ObjectReader(t)
          succeededCount <- obj.readOpt[Int]("succeededCount")
          succeededIndexes <- obj.readOpt[String]("succeededIndexes")
      } yield SuccessPolicyRule (
          succeededCount = succeededCount,
          succeededIndexes = succeededIndexes
        )
    }
}

