package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes. */
final case class SuccessPolicy(
  rules : Seq[io.k8s.api.batch.v1.SuccessPolicyRule]
) {

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.batch.v1.SuccessPolicyRule]) : SuccessPolicy = copy(rules = value)
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.batch.v1.SuccessPolicyRule*) : SuccessPolicy = copy(rules = rules ++ newValues)
  /** transforms rules to result of function */
  def mapRules(f: Seq[io.k8s.api.batch.v1.SuccessPolicyRule] => Seq[io.k8s.api.batch.v1.SuccessPolicyRule]) : SuccessPolicy = copy(rules = f(rules))
}

object SuccessPolicy {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.SuccessPolicy] = new Encoder[io.k8s.api.batch.v1.SuccessPolicy] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.SuccessPolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rules", o.rules)
            .build
        }
    }

    implicit val decoder: Decoder[SuccessPolicy] = new Decoder[SuccessPolicy] {
      def apply[T : Reader](t: T): Either[String, SuccessPolicy] = for {
          obj <- ObjectReader(t)
          rules <- obj.read[Seq[io.k8s.api.batch.v1.SuccessPolicyRule]]("rules")
      } yield SuccessPolicy (
          rules = rules
        )
    }
}

