package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** JobSpec describes how the job execution will look like. */
final case class JobSpec(
  template : io.k8s.api.core.v1.PodTemplateSpec,
  parallelism : Option[Int] = None,
  podReplacementPolicy : Option[String] = None,
  completionMode : Option[String] = None,
  maxFailedIndexes : Option[Int] = None,
  podFailurePolicy : Option[io.k8s.api.batch.v1.PodFailurePolicy] = None,
  manualSelector : Option[Boolean] = None,
  backoffLimitPerIndex : Option[Int] = None,
  suspend : Option[Boolean] = None,
  managedBy : Option[String] = None,
  backoffLimit : Option[Int] = None,
  activeDeadlineSeconds : Option[Long] = None,
  completions : Option[Int] = None,
  ttlSecondsAfterFinished : Option[Int] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  successPolicy : Option[io.k8s.api.batch.v1.SuccessPolicy] = None
) {

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : JobSpec = copy(template = value)
  /** transforms template to result of function */
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : JobSpec = copy(template = f(template))

  /** Returns a new data with parallelism set to new value */
  def withParallelism(value: Int) : JobSpec = copy(parallelism = Some(value))
  /** if parallelism has a value, transforms to the result of function*/
  def mapParallelism(f: Int => Int) : JobSpec = copy(parallelism = parallelism.map(f))

  /** Returns a new data with podReplacementPolicy set to new value */
  def withPodReplacementPolicy(value: String) : JobSpec = copy(podReplacementPolicy = Some(value))
  /** if podReplacementPolicy has a value, transforms to the result of function*/
  def mapPodReplacementPolicy(f: String => String) : JobSpec = copy(podReplacementPolicy = podReplacementPolicy.map(f))

  /** Returns a new data with completionMode set to new value */
  def withCompletionMode(value: String) : JobSpec = copy(completionMode = Some(value))
  /** if completionMode has a value, transforms to the result of function*/
  def mapCompletionMode(f: String => String) : JobSpec = copy(completionMode = completionMode.map(f))

  /** Returns a new data with maxFailedIndexes set to new value */
  def withMaxFailedIndexes(value: Int) : JobSpec = copy(maxFailedIndexes = Some(value))
  /** if maxFailedIndexes has a value, transforms to the result of function*/
  def mapMaxFailedIndexes(f: Int => Int) : JobSpec = copy(maxFailedIndexes = maxFailedIndexes.map(f))

  /** Returns a new data with podFailurePolicy set to new value */
  def withPodFailurePolicy(value: io.k8s.api.batch.v1.PodFailurePolicy) : JobSpec = copy(podFailurePolicy = Some(value))
  /** if podFailurePolicy has a value, transforms to the result of function*/
  def mapPodFailurePolicy(f: io.k8s.api.batch.v1.PodFailurePolicy => io.k8s.api.batch.v1.PodFailurePolicy) : JobSpec = copy(podFailurePolicy = podFailurePolicy.map(f))

  /** Returns a new data with manualSelector set to new value */
  def withManualSelector(value: Boolean) : JobSpec = copy(manualSelector = Some(value))
  /** if manualSelector has a value, transforms to the result of function*/
  def mapManualSelector(f: Boolean => Boolean) : JobSpec = copy(manualSelector = manualSelector.map(f))

  /** Returns a new data with backoffLimitPerIndex set to new value */
  def withBackoffLimitPerIndex(value: Int) : JobSpec = copy(backoffLimitPerIndex = Some(value))
  /** if backoffLimitPerIndex has a value, transforms to the result of function*/
  def mapBackoffLimitPerIndex(f: Int => Int) : JobSpec = copy(backoffLimitPerIndex = backoffLimitPerIndex.map(f))

  /** Returns a new data with suspend set to new value */
  def withSuspend(value: Boolean) : JobSpec = copy(suspend = Some(value))
  /** if suspend has a value, transforms to the result of function*/
  def mapSuspend(f: Boolean => Boolean) : JobSpec = copy(suspend = suspend.map(f))

  /** Returns a new data with managedBy set to new value */
  def withManagedBy(value: String) : JobSpec = copy(managedBy = Some(value))
  /** if managedBy has a value, transforms to the result of function*/
  def mapManagedBy(f: String => String) : JobSpec = copy(managedBy = managedBy.map(f))

  /** Returns a new data with backoffLimit set to new value */
  def withBackoffLimit(value: Int) : JobSpec = copy(backoffLimit = Some(value))
  /** if backoffLimit has a value, transforms to the result of function*/
  def mapBackoffLimit(f: Int => Int) : JobSpec = copy(backoffLimit = backoffLimit.map(f))

  /** Returns a new data with activeDeadlineSeconds set to new value */
  def withActiveDeadlineSeconds(value: Long) : JobSpec = copy(activeDeadlineSeconds = Some(value))
  /** if activeDeadlineSeconds has a value, transforms to the result of function*/
  def mapActiveDeadlineSeconds(f: Long => Long) : JobSpec = copy(activeDeadlineSeconds = activeDeadlineSeconds.map(f))

  /** Returns a new data with completions set to new value */
  def withCompletions(value: Int) : JobSpec = copy(completions = Some(value))
  /** if completions has a value, transforms to the result of function*/
  def mapCompletions(f: Int => Int) : JobSpec = copy(completions = completions.map(f))

  /** Returns a new data with ttlSecondsAfterFinished set to new value */
  def withTtlSecondsAfterFinished(value: Int) : JobSpec = copy(ttlSecondsAfterFinished = Some(value))
  /** if ttlSecondsAfterFinished has a value, transforms to the result of function*/
  def mapTtlSecondsAfterFinished(f: Int => Int) : JobSpec = copy(ttlSecondsAfterFinished = ttlSecondsAfterFinished.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : JobSpec = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : JobSpec = copy(selector = selector.map(f))

  /** Returns a new data with successPolicy set to new value */
  def withSuccessPolicy(value: io.k8s.api.batch.v1.SuccessPolicy) : JobSpec = copy(successPolicy = Some(value))
  /** if successPolicy has a value, transforms to the result of function*/
  def mapSuccessPolicy(f: io.k8s.api.batch.v1.SuccessPolicy => io.k8s.api.batch.v1.SuccessPolicy) : JobSpec = copy(successPolicy = successPolicy.map(f))
}

object JobSpec {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.JobSpec] = new Encoder[io.k8s.api.batch.v1.JobSpec] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.JobSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("template", o.template)
            .write("parallelism", o.parallelism)
            .write("podReplacementPolicy", o.podReplacementPolicy)
            .write("completionMode", o.completionMode)
            .write("maxFailedIndexes", o.maxFailedIndexes)
            .write("podFailurePolicy", o.podFailurePolicy)
            .write("manualSelector", o.manualSelector)
            .write("backoffLimitPerIndex", o.backoffLimitPerIndex)
            .write("suspend", o.suspend)
            .write("managedBy", o.managedBy)
            .write("backoffLimit", o.backoffLimit)
            .write("activeDeadlineSeconds", o.activeDeadlineSeconds)
            .write("completions", o.completions)
            .write("ttlSecondsAfterFinished", o.ttlSecondsAfterFinished)
            .write("selector", o.selector)
            .write("successPolicy", o.successPolicy)
            .build
        }
    }

    implicit val decoder: Decoder[JobSpec] = new Decoder[JobSpec] {
      def apply[T : Reader](t: T): Either[String, JobSpec] = for {
          obj <- ObjectReader(t)
          template <- obj.read[io.k8s.api.core.v1.PodTemplateSpec]("template")
          parallelism <- obj.readOpt[Int]("parallelism")
          podReplacementPolicy <- obj.readOpt[String]("podReplacementPolicy")
          completionMode <- obj.readOpt[String]("completionMode")
          maxFailedIndexes <- obj.readOpt[Int]("maxFailedIndexes")
          podFailurePolicy <- obj.readOpt[io.k8s.api.batch.v1.PodFailurePolicy]("podFailurePolicy")
          manualSelector <- obj.readOpt[Boolean]("manualSelector")
          backoffLimitPerIndex <- obj.readOpt[Int]("backoffLimitPerIndex")
          suspend <- obj.readOpt[Boolean]("suspend")
          managedBy <- obj.readOpt[String]("managedBy")
          backoffLimit <- obj.readOpt[Int]("backoffLimit")
          activeDeadlineSeconds <- obj.readOpt[Long]("activeDeadlineSeconds")
          completions <- obj.readOpt[Int]("completions")
          ttlSecondsAfterFinished <- obj.readOpt[Int]("ttlSecondsAfterFinished")
          selector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
          successPolicy <- obj.readOpt[io.k8s.api.batch.v1.SuccessPolicy]("successPolicy")
      } yield JobSpec (
          template = template,
          parallelism = parallelism,
          podReplacementPolicy = podReplacementPolicy,
          completionMode = completionMode,
          maxFailedIndexes = maxFailedIndexes,
          podFailurePolicy = podFailurePolicy,
          manualSelector = manualSelector,
          backoffLimitPerIndex = backoffLimitPerIndex,
          suspend = suspend,
          managedBy = managedBy,
          backoffLimit = backoffLimit,
          activeDeadlineSeconds = activeDeadlineSeconds,
          completions = completions,
          ttlSecondsAfterFinished = ttlSecondsAfterFinished,
          selector = selector,
          successPolicy = successPolicy
        )
    }
}

