package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.utils._

/** Variable is the definition of a variable that is used for composition. A variable is defined as a named expression. */
final case class Variable(
  expression : String,
  name : String
) {

  /** Returns a new data with expression set to new value */
  def withExpression(value: String) : Variable = copy(expression = value)
  /** transforms expression to result of function */
  def mapExpression(f: String => String) : Variable = copy(expression = f(expression))

  /** Returns a new data with name set to new value */
  def withName(value: String) : Variable = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : Variable = copy(name = f(name))
}

object Variable {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.Variable] = new Encoder[io.k8s.api.admissionregistration.v1.Variable] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.Variable) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("expression", o.expression)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[Variable] = new Decoder[Variable] {
      def apply[T : Reader](t: T): Either[String, Variable] = for {
          obj <- ObjectReader(t)
          expression <- obj.read[String]("expression")
          name <- obj.read[String]("name")
      } yield Variable (
          expression = expression,
          name = name
        )
    }
}

