package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.

For a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.

The CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget. */
final case class ValidatingAdmissionPolicyBinding(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingAdmissionPolicyBinding", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingAdmissionPolicyBinding = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingAdmissionPolicyBinding = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec) : ValidatingAdmissionPolicyBinding = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec => io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec) : ValidatingAdmissionPolicyBinding = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = ValidatingAdmissionPolicyBinding.encoder.apply(this)
}

object ValidatingAdmissionPolicyBinding {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBinding] = new Encoder[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBinding] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBinding) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ValidatingAdmissionPolicyBinding] = new Decoder[ValidatingAdmissionPolicyBinding] {
      def apply[T : Reader](t: T): Either[String, ValidatingAdmissionPolicyBinding] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.admissionregistration.v1.ValidatingAdmissionPolicyBindingSpec]("spec")
      } yield ValidatingAdmissionPolicyBinding (
          metadata = metadata,
          spec = spec
        )
    }
}

