package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressLoadBalancerStatus represents the status of a load-balancer. */
final case class IngressLoadBalancerStatus(
  ingress : Option[Seq[io.k8s.api.networking.v1.IngressLoadBalancerIngress]] = None
) {

  /** Returns a new data with ingress set to new value */
  def withIngress(value: Seq[io.k8s.api.networking.v1.IngressLoadBalancerIngress]) : IngressLoadBalancerStatus = copy(ingress = Some(value))
  /** Appends new values to ingress */
  def addIngress(newValues: io.k8s.api.networking.v1.IngressLoadBalancerIngress*) : IngressLoadBalancerStatus = copy(ingress = Some(ingress.fold(newValues)(_ ++ newValues)))
  /** if ingress has a value, transforms to the result of function*/
  def mapIngress(f: Seq[io.k8s.api.networking.v1.IngressLoadBalancerIngress] => Seq[io.k8s.api.networking.v1.IngressLoadBalancerIngress]) : IngressLoadBalancerStatus = copy(ingress = ingress.map(f))
}

object IngressLoadBalancerStatus {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressLoadBalancerStatus] = new Encoder[io.k8s.api.networking.v1.IngressLoadBalancerStatus] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressLoadBalancerStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ingress", o.ingress)
            .build
        }
    }

    implicit val decoder: Decoder[IngressLoadBalancerStatus] = new Decoder[IngressLoadBalancerStatus] {
      def apply[T : Reader](t: T): Either[String, IngressLoadBalancerStatus] = for {
          obj <- ObjectReader(t)
          ingress <- obj.readOpt[Seq[io.k8s.api.networking.v1.IngressLoadBalancerIngress]]("ingress")
      } yield IngressLoadBalancerStatus (
          ingress = ingress
        )
    }
}

