package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane. */
final case class PodStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.PodCondition]] = None,
  qosClass : Option[String] = None,
  startTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  phase : Option[String] = None,
  reason : Option[String] = None,
  resize : Option[String] = None,
  ephemeralContainerStatuses : Option[Seq[io.k8s.api.core.v1.ContainerStatus]] = None,
  hostIP : Option[String] = None,
  message : Option[String] = None,
  containerStatuses : Option[Seq[io.k8s.api.core.v1.ContainerStatus]] = None,
  podIP : Option[String] = None,
  nominatedNodeName : Option[String] = None,
  podIPs : Option[Seq[io.k8s.api.core.v1.PodIP]] = None,
  initContainerStatuses : Option[Seq[io.k8s.api.core.v1.ContainerStatus]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.core.v1.PodCondition]) : PodStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.core.v1.PodCondition*) : PodStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.core.v1.PodCondition] => Seq[io.k8s.api.core.v1.PodCondition]) : PodStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with qosClass set to new value */
  def withQosClass(value: String) : PodStatus = copy(qosClass = Some(value))
  /** if qosClass has a value, transforms to the result of function*/
  def mapQosClass(f: String => String) : PodStatus = copy(qosClass = qosClass.map(f))

  /** Returns a new data with startTime set to new value */
  def withStartTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodStatus = copy(startTime = Some(value))
  /** if startTime has a value, transforms to the result of function*/
  def mapStartTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PodStatus = copy(startTime = startTime.map(f))

  /** Returns a new data with phase set to new value */
  def withPhase(value: String) : PodStatus = copy(phase = Some(value))
  /** if phase has a value, transforms to the result of function*/
  def mapPhase(f: String => String) : PodStatus = copy(phase = phase.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : PodStatus = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : PodStatus = copy(reason = reason.map(f))

  /** Returns a new data with resize set to new value */
  def withResize(value: String) : PodStatus = copy(resize = Some(value))
  /** if resize has a value, transforms to the result of function*/
  def mapResize(f: String => String) : PodStatus = copy(resize = resize.map(f))

  /** Returns a new data with ephemeralContainerStatuses set to new value */
  def withEphemeralContainerStatuses(value: Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(ephemeralContainerStatuses = Some(value))
  /** Appends new values to ephemeralContainerStatuses */
  def addEphemeralContainerStatuses(newValues: io.k8s.api.core.v1.ContainerStatus*) : PodStatus = copy(ephemeralContainerStatuses = Some(ephemeralContainerStatuses.fold(newValues)(_ ++ newValues)))
  /** if ephemeralContainerStatuses has a value, transforms to the result of function*/
  def mapEphemeralContainerStatuses(f: Seq[io.k8s.api.core.v1.ContainerStatus] => Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(ephemeralContainerStatuses = ephemeralContainerStatuses.map(f))

  /** Returns a new data with hostIP set to new value */
  def withHostIP(value: String) : PodStatus = copy(hostIP = Some(value))
  /** if hostIP has a value, transforms to the result of function*/
  def mapHostIP(f: String => String) : PodStatus = copy(hostIP = hostIP.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : PodStatus = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : PodStatus = copy(message = message.map(f))

  /** Returns a new data with containerStatuses set to new value */
  def withContainerStatuses(value: Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(containerStatuses = Some(value))
  /** Appends new values to containerStatuses */
  def addContainerStatuses(newValues: io.k8s.api.core.v1.ContainerStatus*) : PodStatus = copy(containerStatuses = Some(containerStatuses.fold(newValues)(_ ++ newValues)))
  /** if containerStatuses has a value, transforms to the result of function*/
  def mapContainerStatuses(f: Seq[io.k8s.api.core.v1.ContainerStatus] => Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(containerStatuses = containerStatuses.map(f))

  /** Returns a new data with podIP set to new value */
  def withPodIP(value: String) : PodStatus = copy(podIP = Some(value))
  /** if podIP has a value, transforms to the result of function*/
  def mapPodIP(f: String => String) : PodStatus = copy(podIP = podIP.map(f))

  /** Returns a new data with nominatedNodeName set to new value */
  def withNominatedNodeName(value: String) : PodStatus = copy(nominatedNodeName = Some(value))
  /** if nominatedNodeName has a value, transforms to the result of function*/
  def mapNominatedNodeName(f: String => String) : PodStatus = copy(nominatedNodeName = nominatedNodeName.map(f))

  /** Returns a new data with podIPs set to new value */
  def withPodIPs(value: Seq[io.k8s.api.core.v1.PodIP]) : PodStatus = copy(podIPs = Some(value))
  /** Appends new values to podIPs */
  def addPodIPs(newValues: io.k8s.api.core.v1.PodIP*) : PodStatus = copy(podIPs = Some(podIPs.fold(newValues)(_ ++ newValues)))
  /** if podIPs has a value, transforms to the result of function*/
  def mapPodIPs(f: Seq[io.k8s.api.core.v1.PodIP] => Seq[io.k8s.api.core.v1.PodIP]) : PodStatus = copy(podIPs = podIPs.map(f))

  /** Returns a new data with initContainerStatuses set to new value */
  def withInitContainerStatuses(value: Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(initContainerStatuses = Some(value))
  /** Appends new values to initContainerStatuses */
  def addInitContainerStatuses(newValues: io.k8s.api.core.v1.ContainerStatus*) : PodStatus = copy(initContainerStatuses = Some(initContainerStatuses.fold(newValues)(_ ++ newValues)))
  /** if initContainerStatuses has a value, transforms to the result of function*/
  def mapInitContainerStatuses(f: Seq[io.k8s.api.core.v1.ContainerStatus] => Seq[io.k8s.api.core.v1.ContainerStatus]) : PodStatus = copy(initContainerStatuses = initContainerStatuses.map(f))
}

object PodStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodStatus] = new Encoder[io.k8s.api.core.v1.PodStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("qosClass", o.qosClass)
            .write("startTime", o.startTime)
            .write("phase", o.phase)
            .write("reason", o.reason)
            .write("resize", o.resize)
            .write("ephemeralContainerStatuses", o.ephemeralContainerStatuses)
            .write("hostIP", o.hostIP)
            .write("message", o.message)
            .write("containerStatuses", o.containerStatuses)
            .write("podIP", o.podIP)
            .write("nominatedNodeName", o.nominatedNodeName)
            .write("podIPs", o.podIPs)
            .write("initContainerStatuses", o.initContainerStatuses)
            .build
        }
    }

    implicit val decoder: Decoder[PodStatus] = new Decoder[PodStatus] {
      def apply[T : Reader](t: T): Either[String, PodStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.core.v1.PodCondition]]("conditions")
          qosClass <- obj.readOpt[String]("qosClass")
          startTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("startTime")
          phase <- obj.readOpt[String]("phase")
          reason <- obj.readOpt[String]("reason")
          resize <- obj.readOpt[String]("resize")
          ephemeralContainerStatuses <- obj.readOpt[Seq[io.k8s.api.core.v1.ContainerStatus]]("ephemeralContainerStatuses")
          hostIP <- obj.readOpt[String]("hostIP")
          message <- obj.readOpt[String]("message")
          containerStatuses <- obj.readOpt[Seq[io.k8s.api.core.v1.ContainerStatus]]("containerStatuses")
          podIP <- obj.readOpt[String]("podIP")
          nominatedNodeName <- obj.readOpt[String]("nominatedNodeName")
          podIPs <- obj.readOpt[Seq[io.k8s.api.core.v1.PodIP]]("podIPs")
          initContainerStatuses <- obj.readOpt[Seq[io.k8s.api.core.v1.ContainerStatus]]("initContainerStatuses")
      } yield PodStatus (
          conditions = conditions,
          qosClass = qosClass,
          startTime = startTime,
          phase = phase,
          reason = reason,
          resize = resize,
          ephemeralContainerStatuses = ephemeralContainerStatuses,
          hostIP = hostIP,
          message = message,
          containerStatuses = containerStatuses,
          podIP = podIP,
          nominatedNodeName = nominatedNodeName,
          podIPs = podIPs,
          initContainerStatuses = initContainerStatuses
        )
    }
}

