package io.k8s.api.networking.v1


/** IngressServiceBackend references a Kubernetes Service as a Backend. */
final case class IngressServiceBackend(
  name : String,
  port : Option[io.k8s.api.networking.v1.ServiceBackendPort] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : IngressServiceBackend = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : IngressServiceBackend = copy(name = f(name))

  /** Returns a new data with port set to new value */
  def withPort(value: io.k8s.api.networking.v1.ServiceBackendPort) : IngressServiceBackend = copy(port = Some(value))
  /** if port has a value, transforms to the result of function*/
  def mapPort(f: io.k8s.api.networking.v1.ServiceBackendPort => io.k8s.api.networking.v1.ServiceBackendPort) : IngressServiceBackend = copy(port = port.map(f))
}

