package io.k8s.api.flowcontrol.v1beta2


/** LimitResponse defines how to handle requests that can not be executed right now. */
final case class LimitResponse(
  `type` : String,
  queuing : Option[io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : LimitResponse = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : LimitResponse = copy(`type` = f(`type`))

  /** Returns a new data with queuing set to new value */
  def withQueuing(value: io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration) : LimitResponse = copy(queuing = Some(value))
  /** if queuing has a value, transforms to the result of function*/
  def mapQueuing(f: io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration => io.k8s.api.flowcontrol.v1beta2.QueuingConfiguration) : LimitResponse = copy(queuing = queuing.map(f))
}

