package io.k8s.api.flowcontrol.v1beta1


/** GroupSubject holds detailed information for group-kind subject. */
final case class GroupSubject(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : GroupSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : GroupSubject = copy(name = f(name))
}

