package io.k8s.api.core.v1


/** VolumeMount describes a mounting of a Volume within a container. */
final case class VolumeMount(
  name : String,
  mountPath : String,
  subPath : Option[String] = None,
  mountPropagation : Option[String] = None,
  readOnly : Option[Boolean] = None,
  subPathExpr : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : VolumeMount = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : VolumeMount = copy(name = f(name))

  /** Returns a new data with mountPath set to new value */
  def withMountPath(value: String) : VolumeMount = copy(mountPath = value)
  /** transforms mountPath to result of function */
  def mapMountPath(f: String => String) : VolumeMount = copy(mountPath = f(mountPath))

  /** Returns a new data with subPath set to new value */
  def withSubPath(value: String) : VolumeMount = copy(subPath = Some(value))
  /** if subPath has a value, transforms to the result of function*/
  def mapSubPath(f: String => String) : VolumeMount = copy(subPath = subPath.map(f))

  /** Returns a new data with mountPropagation set to new value */
  def withMountPropagation(value: String) : VolumeMount = copy(mountPropagation = Some(value))
  /** if mountPropagation has a value, transforms to the result of function*/
  def mapMountPropagation(f: String => String) : VolumeMount = copy(mountPropagation = mountPropagation.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : VolumeMount = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : VolumeMount = copy(readOnly = readOnly.map(f))

  /** Returns a new data with subPathExpr set to new value */
  def withSubPathExpr(value: String) : VolumeMount = copy(subPathExpr = Some(value))
  /** if subPathExpr has a value, transforms to the result of function*/
  def mapSubPathExpr(f: String => String) : VolumeMount = copy(subPathExpr = subPathExpr.map(f))
}

