package io.k8s.api.core.v1


/** A topology selector term represents the result of label queries. A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future. */
final case class TopologySelectorTerm(
  matchLabelExpressions : Option[Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]] = None
) {

  /** Returns a new data with matchLabelExpressions set to new value */
  def withMatchLabelExpressions(value: Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]) : TopologySelectorTerm = copy(matchLabelExpressions = Some(value))
  /** Appends new values to matchLabelExpressions */
  def addMatchLabelExpressions(newValues: io.k8s.api.core.v1.TopologySelectorLabelRequirement*) : TopologySelectorTerm = copy(matchLabelExpressions = Some(matchLabelExpressions.fold(newValues)(_ ++ newValues)))
  /** if matchLabelExpressions has a value, transforms to the result of function*/
  def mapMatchLabelExpressions(f: Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement] => Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]) : TopologySelectorTerm = copy(matchLabelExpressions = matchLabelExpressions.map(f))
}

