package io.k8s.api.core.v1


/** TCPSocketAction describes an action based on opening a socket */
final case class TCPSocketAction(
  port : io.k8s.apimachinery.pkg.util.intstr.IntOrString,
  host : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : TCPSocketAction = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : TCPSocketAction = copy(port = f(port))

  /** Returns a new data with host set to new value */
  def withHost(value: String) : TCPSocketAction = copy(host = Some(value))
  /** if host has a value, transforms to the result of function*/
  def mapHost(f: String => String) : TCPSocketAction = copy(host = host.map(f))
}

