package io.k8s.api.core.v1


/** ServicePort contains information on service's port. */
final case class ServicePort(
  port : Int,
  nodePort : Option[Int] = None,
  name : Option[String] = None,
  targetPort : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  protocol : Option[String] = None,
  appProtocol : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : ServicePort = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : ServicePort = copy(port = f(port))

  /** Returns a new data with nodePort set to new value */
  def withNodePort(value: Int) : ServicePort = copy(nodePort = Some(value))
  /** if nodePort has a value, transforms to the result of function*/
  def mapNodePort(f: Int => Int) : ServicePort = copy(nodePort = nodePort.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServicePort = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ServicePort = copy(name = name.map(f))

  /** Returns a new data with targetPort set to new value */
  def withTargetPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : ServicePort = copy(targetPort = Some(value))
  /** if targetPort has a value, transforms to the result of function*/
  def mapTargetPort(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : ServicePort = copy(targetPort = targetPort.map(f))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : ServicePort = copy(protocol = Some(value))
  /** if protocol has a value, transforms to the result of function*/
  def mapProtocol(f: String => String) : ServicePort = copy(protocol = protocol.map(f))

  /** Returns a new data with appProtocol set to new value */
  def withAppProtocol(value: String) : ServicePort = copy(appProtocol = Some(value))
  /** if appProtocol has a value, transforms to the result of function*/
  def mapAppProtocol(f: String => String) : ServicePort = copy(appProtocol = appProtocol.map(f))
}

