package io.k8s.api.core.v1


/** Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling. */
final case class ISCSIVolumeSource(
  iqn : String,
  targetPortal : String,
  lun : Int,
  portals : Option[Seq[String]] = None,
  readOnly : Option[Boolean] = None,
  chapAuthDiscovery : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  initiatorName : Option[String] = None,
  iscsiInterface : Option[String] = None,
  chapAuthSession : Option[Boolean] = None
) {

  /** Returns a new data with iqn set to new value */
  def withIqn(value: String) : ISCSIVolumeSource = copy(iqn = value)
  /** transforms iqn to result of function */
  def mapIqn(f: String => String) : ISCSIVolumeSource = copy(iqn = f(iqn))

  /** Returns a new data with targetPortal set to new value */
  def withTargetPortal(value: String) : ISCSIVolumeSource = copy(targetPortal = value)
  /** transforms targetPortal to result of function */
  def mapTargetPortal(f: String => String) : ISCSIVolumeSource = copy(targetPortal = f(targetPortal))

  /** Returns a new data with lun set to new value */
  def withLun(value: Int) : ISCSIVolumeSource = copy(lun = value)
  /** transforms lun to result of function */
  def mapLun(f: Int => Int) : ISCSIVolumeSource = copy(lun = f(lun))

  /** Returns a new data with portals set to new value */
  def withPortals(value: Seq[String]) : ISCSIVolumeSource = copy(portals = Some(value))
  /** Appends new values to portals */
  def addPortals(newValues: String*) : ISCSIVolumeSource = copy(portals = Some(portals.fold(newValues)(_ ++ newValues)))
  /** if portals has a value, transforms to the result of function*/
  def mapPortals(f: Seq[String] => Seq[String]) : ISCSIVolumeSource = copy(portals = portals.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : ISCSIVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : ISCSIVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with chapAuthDiscovery set to new value */
  def withChapAuthDiscovery(value: Boolean) : ISCSIVolumeSource = copy(chapAuthDiscovery = Some(value))
  /** if chapAuthDiscovery has a value, transforms to the result of function*/
  def mapChapAuthDiscovery(f: Boolean => Boolean) : ISCSIVolumeSource = copy(chapAuthDiscovery = chapAuthDiscovery.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : ISCSIVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : ISCSIVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : ISCSIVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : ISCSIVolumeSource = copy(secretRef = secretRef.map(f))

  /** Returns a new data with initiatorName set to new value */
  def withInitiatorName(value: String) : ISCSIVolumeSource = copy(initiatorName = Some(value))
  /** if initiatorName has a value, transforms to the result of function*/
  def mapInitiatorName(f: String => String) : ISCSIVolumeSource = copy(initiatorName = initiatorName.map(f))

  /** Returns a new data with iscsiInterface set to new value */
  def withIscsiInterface(value: String) : ISCSIVolumeSource = copy(iscsiInterface = Some(value))
  /** if iscsiInterface has a value, transforms to the result of function*/
  def mapIscsiInterface(f: String => String) : ISCSIVolumeSource = copy(iscsiInterface = iscsiInterface.map(f))

  /** Returns a new data with chapAuthSession set to new value */
  def withChapAuthSession(value: Boolean) : ISCSIVolumeSource = copy(chapAuthSession = Some(value))
  /** if chapAuthSession has a value, transforms to the result of function*/
  def mapChapAuthSession(f: Boolean => Boolean) : ISCSIVolumeSource = copy(chapAuthSession = chapAuthSession.map(f))
}

