package io.k8s.api.core.v1


/** EnvFromSource represents the source of a set of ConfigMaps */
final case class EnvFromSource(
  configMapRef : Option[io.k8s.api.core.v1.ConfigMapEnvSource] = None,
  prefix : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.SecretEnvSource] = None
) {

  /** Returns a new data with configMapRef set to new value */
  def withConfigMapRef(value: io.k8s.api.core.v1.ConfigMapEnvSource) : EnvFromSource = copy(configMapRef = Some(value))
  /** if configMapRef has a value, transforms to the result of function*/
  def mapConfigMapRef(f: io.k8s.api.core.v1.ConfigMapEnvSource => io.k8s.api.core.v1.ConfigMapEnvSource) : EnvFromSource = copy(configMapRef = configMapRef.map(f))

  /** Returns a new data with prefix set to new value */
  def withPrefix(value: String) : EnvFromSource = copy(prefix = Some(value))
  /** if prefix has a value, transforms to the result of function*/
  def mapPrefix(f: String => String) : EnvFromSource = copy(prefix = prefix.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.SecretEnvSource) : EnvFromSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.SecretEnvSource => io.k8s.api.core.v1.SecretEnvSource) : EnvFromSource = copy(secretRef = secretRef.map(f))
}

