package io.k8s.api.core.v1


/** Describe a container image */
final case class ContainerImage(
  names : Option[Seq[String]] = None,
  sizeBytes : Option[Int] = None
) {

  /** Returns a new data with names set to new value */
  def withNames(value: Seq[String]) : ContainerImage = copy(names = Some(value))
  /** Appends new values to names */
  def addNames(newValues: String*) : ContainerImage = copy(names = Some(names.fold(newValues)(_ ++ newValues)))
  /** if names has a value, transforms to the result of function*/
  def mapNames(f: Seq[String] => Seq[String]) : ContainerImage = copy(names = names.map(f))

  /** Returns a new data with sizeBytes set to new value */
  def withSizeBytes(value: Int) : ContainerImage = copy(sizeBytes = Some(value))
  /** if sizeBytes has a value, transforms to the result of function*/
  def mapSizeBytes(f: Int => Int) : ContainerImage = copy(sizeBytes = sizeBytes.map(f))
}

