package io.k8s.api.core.v1


/** Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling. */
final case class CephFSPersistentVolumeSource(
  monitors : Seq[String],
  path : Option[String] = None,
  readOnly : Option[Boolean] = None,
  secretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  secretFile : Option[String] = None,
  user : Option[String] = None
) {

  /** Returns a new data with monitors set to new value */
  def withMonitors(value: Seq[String]) : CephFSPersistentVolumeSource = copy(monitors = value)
  /** Appends new values to monitors */
  def addMonitors(newValues: String*) : CephFSPersistentVolumeSource = copy(monitors = monitors ++ newValues)
  /** transforms monitors to result of function */
  def mapMonitors(f: Seq[String] => Seq[String]) : CephFSPersistentVolumeSource = copy(monitors = f(monitors))

  /** Returns a new data with path set to new value */
  def withPath(value: String) : CephFSPersistentVolumeSource = copy(path = Some(value))
  /** if path has a value, transforms to the result of function*/
  def mapPath(f: String => String) : CephFSPersistentVolumeSource = copy(path = path.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : CephFSPersistentVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : CephFSPersistentVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : CephFSPersistentVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : CephFSPersistentVolumeSource = copy(secretRef = secretRef.map(f))

  /** Returns a new data with secretFile set to new value */
  def withSecretFile(value: String) : CephFSPersistentVolumeSource = copy(secretFile = Some(value))
  /** if secretFile has a value, transforms to the result of function*/
  def mapSecretFile(f: String => String) : CephFSPersistentVolumeSource = copy(secretFile = secretFile.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: String) : CephFSPersistentVolumeSource = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: String => String) : CephFSPersistentVolumeSource = copy(user = user.map(f))
}

